﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

using MicroRWD.Common;

namespace MicroRWD.UI.QT
{
    public partial class Hitag1_S_MemoryPanel : UserControl
    {
        private class ReadWorker
        {
            private const byte C_LAST_PAGE = 0x3f;

            private Hitag1_S_MemoryPanel parent;
            private ReadTagProgress progress;

            public ReadWorker(Hitag1_S_MemoryPanel _parent, ReadTagProgress _progress)
            {
                parent = _parent;
                progress = _progress;
            }

            public void DoWork()
            {
                try
                {
                    // Clear the tag listview
                    for (byte page = 0x00; page <= C_LAST_PAGE; ++page)
                    {
                        // Clear data
                        parent.UpdateRow(page, "", "");
                    }

                    // Read tag page by page
                    for (byte page = 0x00; (page <= C_LAST_PAGE) && !progress.Cancel; ++page)
                    {
                        // Delegate read to reader
                        byte[] reply = Program.Controller.Reader.CmdTagRead(page);

                        // Check for reply
                        if (reply.Length > 0)
                        {
                            // Check for data
                            if (reply.Length == 5)
                            {
                                // Extract data
                                byte[] data = new byte[4];
                                for (int i = 0; i < 4; ++i)
                                {
                                    data[i] = reply[i + 1];
                                }

                                // Copy data into list view
                                parent.UpdateRow(page, String.Join(string.Empty, Array.ConvertAll(data, b => b.ToString("X2") + ' ')), String.Join(string.Empty, Array.ConvertAll(data, b => ((b > 31) && (b < 127)) ? ((char)b).ToString() + ' ' : ". ")));
                            }
                            else
                            {
                                // Copy data into list view
                                parent.UpdateRow(page, "<NO DATA>", "");
                            }
                        }
                        else
                        {
                            // Clear data
                            parent.UpdateRow(page, "", "");
                        }

                        // Update progress bar
                        parent.UpdateProgress(page * 100 / C_LAST_PAGE);
                    }

                    // Close progress dialog
                    parent.WorkerDone();
                }
                catch (Exception ex)
                {
                    // Error
                    Log.Error(ex.ToString());
                }
            }
        }

        // Create progress dialog
        private ReadTagProgress progress;

        public Hitag1_S_MemoryPanel()
        {
            InitializeComponent();

            // Load Hitag 1/S Memory Definitions
            tagListView.Items.Add(new ListViewItem(new string[] { "00", "", "", "Serial Number" }));
            tagListView.Items.Add(new ListViewItem(new string[] { "01", "", "", "Config Bytes" }));
            for (byte i = 0x02; i <= 0x0f; ++i)
            {
                tagListView.Items.Add(new ListViewItem(new string[] { i.ToString("X2"), "", "", "*Reserved*" }));
            }
            for (byte i = 0x10; i <= 0x3f; ++i)
            {
                tagListView.Items.Add(new ListViewItem(new string[] { i.ToString("X2"), "", "", "User Data" }));
            }

            // Select first item
            tagListView.Items[0].Selected = true;
        }

        private void UpdateProgress(int _value)
        {
            this.UIThread(() => progress.Value = _value);
        }

        private void UpdateRow(int _row, string _hex, string _ascii)
        {
            this.UIThread(() => tagListView.Items[_row].SubItems[1].Text = _hex);
            this.UIThread(() => tagListView.Items[_row].SubItems[2].Text = _ascii);
        }

        private void WorkerDone()
        {
            this.UIThread(() => progress.Close());
        }

        private void readTagButton_Click(object sender, EventArgs e)
        {
            // Create progress dialog
            progress = new ReadTagProgress();

            // Create worker to do work asynchronously
            ReadWorker worker = new ReadWorker(this, progress);
            Thread t = new Thread(worker.DoWork);
            t.Start();
            progress.ShowDialog();
            t.Join();
        }

        private void writeToTagButton_Click(object sender, EventArgs e)
        {
            writeToTag();
        }

        private void tagListView_DoubleClick(object sender, EventArgs e)
        {
            writeToTag();
        }

        private void writeToTag()
        {
            int selectedIndex = 0;
            if (tagListView.IsHandleCreated)
            {
                if (tagListView.SelectedIndices.Count > 0)
                {
                    selectedIndex = tagListView.SelectedIndices[0];
                }
                else
                {
                    selectedIndex = 0;
                }
            }
            else
            {
                selectedIndex = 0;
            }

            WriteToTagMemoryForm form = new WriteToTagMemoryForm(4, tagListView, selectedIndex, 3, Program.Controller.Reader);
            form.ShowDialog();
        }
    }
}
